﻿namespace Hims.Api.Models.Ticket
{
    using System;

    /// <summary>
    /// The ticket request filter.
    /// </summary>
    public class TicketRequestFilter
    {
        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int? AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the is admin.
        /// </summary>
        public bool? IsAdmin { get; set; }

        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long? TicketId { get; set; }

        /// <summary>
        /// Gets or sets the ticket timeline id.
        /// </summary>
        public long? TicketTimelineId { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the filter type.
        /// </summary>
        public string FilterType { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string Priority { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string IssueWith { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string MobileNo { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public string? DeviceType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public int? AssigneeAccountId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }
    }

}
